Import-Module Microsoft.Graph.DeviceManagement

####################################################
<# region Authentication
To authenticate, you'll use the Microsoft Graph PowerShell SDK. If you haven't already installed the SDK, see this guide:
https://learn.microsoft.com/en-us/powershell/microsoftgraph/installation?view=graph-powershell-1.0

The PowerShell SDK supports two types of authentication: delegated access, and app-only access.

For details on using delegated access, see this guide here:
https://learn.microsoft.com/powershell/microsoftgraph/get-started?view=graph-powershell-1.0

For details on using app-only access for unattended scenarios, see Use app-only authentication with the Microsoft Graph PowerShell SDK:
https://learn.microsoft.com/powershell/microsoftgraph/app-only?view=graph-powershell-1.0&tabs=azure-portal

#>
#endregion

####################################################

$windows = @"

{
    "@odata.type":  "#microsoft.graph.windows10CustomConfiguration",
    "DisplayName":  "Import_Disable Internet Explorer 11",
    "description":  "Disables IE 11 App",
    "omaSettings":  [
                            {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  null,
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/InternetExplorer/DisableInternetExplorerApp",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e\u003cdata id=\"NotifyDisableIEOptions\" value=\"2\"/\u003e",
                            "displayName":  "Disable IE11"
                            }
                    ]

}

"@

####################################################

New-MgDeviceManagementDeviceConfiguration -BodyParameter $Windows